require( "quest/map/convout.lua" );
combine_speech_tables();

testmap = false; -- set to true to turn on all icons

MAP_SMALL_SCALE = 0.2;
MAP_SMALL_DEPTH = 100;
MAP_LARGE_DEPTH = 10;

map_data = 
{
	{ start_pos = { x = 0, y = 0 }, icon_offset = { x = 0, y = 0 }, scale_pos = { x = 422, y = 12 } }, -- MAP_1
	{ start_pos = { x = 0, y = 0 }, icon_offset = { x = 0, y = 0 }, scale_pos = { x = 612, y = 12 } }, -- MAP_2
	{ start_pos = { x = 0, y = 0 }, icon_offset = { x = 0, y = 0 }, scale_pos = { x = 612, y = 163 } }, -- MAP_3
}

-- map icon 'enums'
ICON_DATA = 
{
	NAME = 1,
	VISIBLE = 2,
	CONDITION = 3,
	OFF = 4,
	ON = 5,
	HALO_WHEN_OFF = 6,
};

map_icons = 
{
	-- name, visible, condition, off, on, off_image, on_image, halo_when_off
	-- MAP_1
	{	
		{ "m1_beauty", true, game:Get("first_time_beauty_salon") > 0, "map_beauty_salon1", "map_beauty_salon2", true },
		{ "m1_diner", true, true, "map_diner1", "map_diner2", true },
		{ "m1_dress", true, game:Get("first_time_dress_shop") > 0, "map_dress_shop1", "map_dress_shop2", true },
		{ "m1_jewelry", true, game:Get("talked_to_ethel") > 0, "map_jewelrystand1", "map_jewelrystand2", true },
		{ "m1_park", true, game:Get("been_to_park") > 0, "map_park1", "map_park2", true },
		{ "m1_pet_shop", true, game:Get("first_time_pet_shop") > 0, "map_pet_shop1", "map_pet_shop2", true },
		{ "m1_pet_spa", true, game:Get("first_time_pet_spa") > 0, "map_pet_spa1", "map_pet_spa2", true },
		{ "m1_subway", true, game:Get("first_time_subway") > 0, "map_subway1_1", "map_subway1_2", true },
		{ "m1_truck", true, game:Get("talked_to_greg_herb") > 0, "map_truck1", "map_truck2", true },
		{ "m1_vw_bug", true, game:Get("talked_to_derek") > 0, "map_vw_bug1", "map_vw_bug2", true },
		{ "m1_window", true, game:Get("first_time_talk_diane") > 0, "map_window1", "map_window2", true },
		
		{ "m1_betty", true, game:Get("first_time_beauty_salon") > 0, "map1_betty1", "map1_betty2", true },
		{ "m1_bobbi", true, game:Get("first_time_dress_shop") > 0, "map1_bobbi1", "map1_bobbi2", true },
		{ "m1_cassie", true, game:Get("first_time_pet_shop") > 0, "map1_cassie1", "map1_cassie2", true },
		{ "m1_derek", true, game:Get("talked_to_derek") > 0, "map1_derek1", "map1_derek2", true },
		{ "m1_diane", true, game:Get("first_time_talk_diane") > 0, "map1_diane1", "map1_diane2", true },
		{ "m1_ethel", true, game:Get("talked_to_ethel") > 0, "map1_ethel1", "map1_ethel2", true },
		{ "m1_gregherb", true, game:Get("talked_to_greg_herb") > 0 or game:Get("got_butterflybag") > 0, "map1_gregherb1", "map1_gregherb2", true },
		{ "m1_walter", true, game:Get("first_time_pet_spa") > 0, "map1_walter1", "map1_walter2", true },
	
		{ "m1_icon01", true, game:Get("cleaned_coffee_spill") > 0, "map1_icon01_blank", "map1_icon01_mop", false },
		{ "m1_icon02", true, game:Get("found_phone") > 0, "map1_icon02_blank", "map1_icon02_phone", false },
		{ "m1_icon03", true, game:Get("got_cofee_cup_from_diner") > 0, "map1_icon03_blank", "map1_icon03_coffee", false },
		{ "m1_icon04", true, game:Get("got_red_dye") > 0, "map1_icon04_blank", "map1_icon04_dye", false },
		{ "m1_icon05", true, quest_complete("find_beads"), "map1_icon05_blank", "map1_icon05_beads", false },
		{ "m1_icon06", true, quest_complete("find_screwdriver"), "map1_icon06_blank", "map1_icon06_screwdriver", false },
		{ "m1_icon07", true, game:Get("got_garment_pole") > 0, "map1_icon07_blank", "map1_icon07_pole", false },
		{ "m1_icon08", true, quest_complete("butterfly_bag"), "map1_icon08_blank", "map1_icon08_bag", false },
		{ "m1_icon09", true, quest_complete("need_dye_remover"), "map1_icon09_blank", "map1_icon09_remover", false },
		{ "m1_icon10", true, quest_complete("beauty_curtains"), "map1_icon10_blank", "map1_icon10_curtains", false },
		{ "m1_icon11", true, game:Get("got_wirecutters") > 0, "map1_icon11_blank", "map1_icon11_cutters", false },
		{ "m1_icon12", true, game:Get("got_oil_can") > 0, "map1_icon12_blank", "map1_icon12_oil", false },
		{ "m1_icon13", true, game:Get("got_snookums") > 0, "map1_icon13_blank", "map1_icon13_dog", false },
		{ "m1_icon14", true, game:Get("got_dog_treat") > 0, "map1_icon14_blank", "map1_icon14_treat", false },
		{ "m1_icon15", true, quest_complete("need_beads"), "map1_icon15_blank", "map1_icon15_necklace", false },
		{ "m1_icon16", true, game:Get("got_subway_token") > 0, "map1_icon16_blank", "map1_icon16_token", false },
		{ "m1_icon17", true, quest_complete("wedding_dress"), "map1_icon17_blank", "map1_icon17_dress", false },
		{ "m1_icon18", true, quest_complete("find_snookums"), "map1_icon18_blank", "map1_icon18_dog", false },
		{ "m1_icon19", true, quest_complete("collect_butterflies1"), "map1_icon19_blank", "map1_icon19_butterfly", false },
	},
	
	-- MAP_2
	{
		{ "m2_bakery", true, game:Get("first_time_bakery") > 0, "map_bakery1", "map_bakery2", true },
		{ "m2_bus", true, game:Get("first_time_sizzle2") > 0, "map_bus1", "map_bus2", true },
		{ "m2_cookiestand", true, game:Get("first_time_sproutstand") > 0, "map_cookiestand1", "map_cookiestand2", true },
		{ "m2_farm", true, game:Get("first_time_farm") > 0, "map_farm1", "map_farm2", true },
		{ "m2_firestation", true, game:Get("first_time_intersection2") > 0, "map_firestation1", "map_firestation2", true },
		{ "m2_gym", true, game:Get("first_time_fitness") > 0, "map_gym1", "map_gym2", true },
		{ "m2_subway", true, game:Get("first_time_subway") > 0, "map_subway2_1", "map_subway2_2", true },
		
		{ "m2_daniel", true, game:Get("first_time_farm") > 0, "map2_daniel1", "map2_daniel2", true },
		{ "m2_ernie", true, game:Get("clicked_ernie") > 0, "map2_ernie1", "map2_ernie2", true },
		{ "m2_fireman", true, game:Get("talk_fireman") > 0, "map2_fireman1", "map2_fireman2", true },
		{ "m2_jo", true, game:Get("first_time_fitness") > 0, "map2_jo1", "map2_jo2", true },
		{ "m2_musician", true, game:Get("talk_musician") > 0, "map2_musician1", "map2_musician2", true },
		{ "m2_sproutgirls", true, game:Get("first_time_talked_to_sprouts") > 0, "map2_sproutgirls1", "map2_sproutgirls2", true },
		{ "m2_stella", true, game:Get("first_time_bakery") > 0, "map2_stella1", "map2_stella2", true },
	
		{ "m2_icon01", true, quest_complete("get_recipe"), "map2_icon01_blank", "map2_icon01_recipe", false },
		{ "m2_icon02", true, quest_added("use_cake_instructions"), "map2_icon02_blank", "map2_icon02_vhs", false },
		{ "m2_icon03", true, quest_complete("info_cake_code"), "map2_icon03_blank", "map2_icon03_cakeomatic", false },
		{ "m2_icon04", true, quest_complete("cake"), "map2_icon04_blank", "map2_icon04_cake", false },
		{ "m2_icon05", true, game:Get("got_subway_token") > 2, "map2_icon05_blank", "map2_icon05_token", false },
		{ "m2_icon06", true, game:Get("found_ten_dollars_in_purse") > 0, "map2_icon06_blank", "map2_icon06_purse", false },
		{ "m2_icon07", true, quest_complete("pass_girl_sprouts"), "map2_icon07_blank", "map2_icon07_dollars", false },
		{ "m2_icon08", true, quest_complete("get_cookies"), "map2_icon08_blank", "map2_icon08_cookies", false },
		{ "m2_icon09", true, quest_complete("use_cake_instructions"), "map2_icon09_blank", "map2_icon09_vcr", false },
		{ "m2_icon10", true, quest_complete("pass_aerobics"), "map2_icon10_blank", "map2_icon10_aerobics", false },
		{ "m2_icon11", true, quest_complete("pass_chickenfield"), "map2_icon11_blank", "map2_icon11_chicken", false },
		{ "m2_icon12", true, quest_complete("get_eggs"), "map2_icon12_blank", "map2_icon12_egg", false },
		{ "m2_icon13", true, quest_complete("get_lugnuts"), "map2_icon13_blank", "map2_icon13_lugnuts", false },
		{ "m2_icon14", true, quest_complete("collect_butterflies2"), "map2_icon14_blank", "map2_icon14_butterfly", false },
	},
	
	-- MAP_3
	{
		{ "m3_apartment", true, game:Get("visited_apartment") > 0, "map_apartment1", "map_apartment2", true },
		{ "m3_bigcorp", true, game:Get("first_time_bigcorp_lobby") > 0, "map_bigcorp1", "map_bigcorp2", true },
		{ "m3_cruiseship", true, game:Get("first_time_cruiseship") > 0, "map_cruiseship1", "map_cruiseship2", true },
		{ "m3_florist", true, game:Get("first_time_flowershop") > 0, "map_florist1", "map_florist2", true },
		{ "m3_newsstand", true, game:Get("bernie_intro_done") > 0, "map_newsstand1", "map_newsstand2", true },
		{ "m3_subway", true, game:Get("first_time_subway") > 0, "map_subway3_1", "map_subway3_2", true },
		
		{ "m3_bernie", true, game:Get("bernie_intro_done") > 0, "map3_bernie1", "map3_bernie2", true },
		{ "m3_colin", true, game:Get("first_time_signatures") > 0, "map3_colin1", "map3_colin2", true },
		{ "m3_hal", true, game:Get("talked_to_hal") > 0, "map3_hal1", "map3_hal2", true },
		{ "m3_marco", true, game:Get("first_time_flowershop") > 0, "map3_marco1", "map3_marco2", true },
		{ "m3_robot", true, game:Get("clicked_quizbot") > 0, "map3_robot1", "map3_robot2", true },
		{ "m3_simon", true, game:Get("talked_to_simon") > 0, "map3_simon1", "map3_simon2", true },
		{ "m3_tina", true, game:Get("talked_to_tina_1") > 0, "map3_tina1", "map3_tina2", true },
	
		{ "m3_icon01", true, quest_added("give_permit"), "map3_icon01_blank", "map3_icon01_construction", false },
		{ "m3_icon02", true, quest_added("keycard1"), "map3_icon02_blank", "map3_icon02_bdaycard", false },
		{ "m3_icon03", true, quest_complete("keycard1"), "map3_icon03_blank", "map3_icon03_elevator", false },
		{ "m3_icon04", true, quest_added("got_permit"), "map3_icon04_blank", "map3_icon04_permit", false },
		{ "m3_icon05", true, game:Get("mugs_found") == 10, "map23icon05_blank", "map3_icon05_mugs", false },
		{ "m3_icon06", true, game:Get("found_orange_pen") > 0, "map3_icon06_blank", "map3_icon06_orangepen", false },
		{ "m3_icon07", true, quest_complete("got_permit"), "map3_icon07_blank", "map3_icon07_redstamp", false },
		{ "m3_icon08", true, game:Get("rose_found_in_flower_shop") == 10, "map3_icon08_blank", "map3_icon08_rose", false },
		{ "m3_icon09", true, game:Get("tulip_found_in_flower_shop") == 10, "map3_icon09_blank", "map3_icon09_tulip", false },
		{ "m3_icon10", true, quest_complete("flowers"), "map3_icon10_blank", "map3_icon10_bouquet", false },
		{ "m3_icon11", true, game:Get("found_apartment_key") > 0, "map3_icon11_blank", "map3_icon11_key1", false },
		{ "m3_icon12", true, quest_complete("unlock_drawer"), "map3_icon12_blank", "map3_icon12_key2", false },
		{ "m3_icon13", true, game:Get("has_reveal_pen") > 0, "map3_icon13_blank", "map3_icon13_revealerpen", false },
		{ "m3_icon14", true, quest_complete("figure_out_clues"), "map3_icon14_blank", "map3_icon14_safecode", false },
		{ "m3_icon15", true, quest_complete("collect_butterflies3"), "map3_icon15_blank", "map3_icon15_butterfly", false },
		{ "m3_icon16", true, game:Get("mg_pizza_activity_round") > 1, "map3_icon16_blank", "map3_icon16_pizza", false },
		{ "m3_icon17", true, game:Get("mg_doughball_activity_round") > 1, "map3_icon17_blank", "map3_icon17_doughball", false },
		{ "m3_icon18", true, quest_complete("got_rings"), "map3_icon18_blank", "map3_icon18_rings", false },
	},
};

neighborhood_text_spec = 
{
	color = { a = 1, r = 0, g = 0, b = 0 },
	y = 0,
	x = 0,
	--w = 800,
	--h = 600,
	bubble = false,
	lineheight = 45,
	outline_size = 0,
	--fixed = true,
	font = "fonts/franklingothic_demicond.mvec"; 
	--anchor = ANCHOR.TOP;
	--halign = HALIGN.LEFT;
};

street_name_text_spec = 
{
	color = { a = 1, r = 0.16, g = 0, b = 0.34 },
	y = 0,
	x = 0,
	--w = 300,
	--h = 600,
	bubble = false,
	lineheight = 50,
	outline_size = 0,
	--fixed = true,
	font = "fonts/franklingothic_demicond.mvec"; 
	--anchor = ANCHOR.TOP;
	--halign = HALIGN.LEFT;
};

coming_soon_text_spec = 
{
	color = { a = 1, r = 0.75, g = 0, b = 0 },
	y = 0,
	x = 0,
	--w = 300,
	--h = 600,
	bubble = false,
	lineheight = 65,
	outline_size = 0,
	--fixed = true,
	font = "fonts/franklingothic_demicond.mvec"; 
	--anchor = ANCHOR.TOP;
	--halign = HALIGN.LEFT;
};

-- map icon 'enums'
TEXT_DATA = 
{
	POSITION = 1,
	TEXT = 2,
	TEXT_SPEC = 3,
};

map_text = 
{
	-- rectangle, text, text_spec
	-- MAP1
	{
		--{ { { x = 628, y = 460 }, { x = 770, y = 460 }, { x = 628, y = 475 }, { x = 770, y = 475 } }, "map_neighbourhood1", neighborhood_text_spec },
		{ { { x = 653, y = 466 }, { x = 795, y = 466 }, { x = 653, y = 490 }, { x = 795, y = 490 } }, "map_ave_flo", neighborhood_text_spec },
		{ { { x = 100, y = 407 }, { x = 250, y = 354 }, { x = 107, y = 425 }, { x = 255, y = 372 } }, "map_florida_st", street_name_text_spec },
		{ { { x = 276, y = 208 }, { x = 429, y = 349 }, { x = 261, y = 224 }, { x = 415, y = 360 } }, "map_spendalot", street_name_text_spec },
	},
	
	-- MAP_2
	{
		--{ { { x = 205, y = 100 }, { x = 535, y = 410 }, { x = 170, y = 140 }, { x = 500, y = 450 } }, "map_coming_soon1", coming_soon_text_spec },
		--{ { { x = 628, y = 460 }, { x = 770, y = 460 }, { x = 628, y = 475 }, { x = 770, y = 475 } }, "map_neighbourhood2", neighborhood_text_spec },
		{ { { x = 653, y = 466 }, { x = 795, y = 466 }, { x = 653, y = 490 }, { x = 795, y = 490 } }, "map_yumyum_square", neighborhood_text_spec },
		{ { { x = 100, y = 407 }, { x = 250, y = 354 }, { x = 107, y = 425 }, { x = 255, y = 372 } }, "map_sunnyside_rd", street_name_text_spec },
		{ { { x = 306, y = 233 }, { x = 429, y = 349 }, { x = 291, y = 249 }, { x = 415, y = 360 } }, "map_sizzle_st", street_name_text_spec },
	},
	
	-- MAP_3
	{
		--{ { { x = 205, y = 100 }, { x = 535, y = 410 }, { x = 170, y = 140 }, { x = 500, y = 450 } }, "map_coming_soon2", coming_soon_text_spec },
		--{ { { x = 628, y = 460 }, { x = 770, y = 460 }, { x = 628, y = 475 }, { x = 770, y = 475 } }, "map_neighbourhood3", neighborhood_text_spec },
		{ { { x = 653, y = 466 }, { x = 795, y = 466 }, { x = 653, y = 490 }, { x = 795, y = 490 } }, "map_bistro_bay", neighborhood_text_spec },
		{ { { x = 160, y = 386 }, { x = 313, y = 330 }, { x = 170, y = 407 }, { x = 323, y = 349 } }, "map_pancake_rd", street_name_text_spec },
		
		{ { { x = 213, y = 151 }, { x = 303, y = 237 }, { x = 197, y = 164 }, { x = 290, y = 250 } }, "map_big_ave", street_name_text_spec },
		{ { { x = 401, y = 321 }, { x = 528, y = 441 }, { x = 386, y = 335 }, { x = 513, y = 454 } }, "map_gravyboat_way", street_name_text_spec },
	},
};

map_name_plate_small = 
{
	{
		position = { x = 492, y = 10 },
		height = 20,
		text = "map_ave_flo",
	},
	
	{
		position = { x = 696, y = 10 },
		height = 20,
		text = "map_yumyum_square",
	},
	
	{
		position = { x = 696, y = 165 },
		height = 20,
		text = "map_bistro_bay",
	},
};

function spawn_maps()	
	for i,v in map_data do
		local new_map = spawn_map(i);
		spawn_map_button(i);
		spawn_map_nameplate_small(i);
		spawn_map_halo(i);
		--spawn_map_icons(i, new_map);
		--table.insert(new_map.children, spawn_name_plate(i));
		--spawn_map_texts(i, new_map);
		--table.insert(new_map.children, spawn_map_halo(i));
		
	end
	
	position_maps();
	
	show_map_icons(game:Get("currently_selected_map"));

	-- now lets wait and pop up everything that pops up when the map is full size
	wait_fade();
	
	scene:SetDrawEnvSlideSpeed(0.06);
	
	while not scene:IsDrawEnvSlideDone() do
		delay(1);
	end
	
	scene:Spawn(flo_spec);
	spawn_button(pause_button_help_spec);
	spawn_button(back_button_spec);
	spawn_help_panel();
	--scene:Spawn(you_are_here_icon_spec);
end

function spawn_map_icons(map_num, map)
	for i,v in map_icons[map_num] do 
		table.insert(map.children, spawn_map_icon(v));
	end;
end

function spawn_map_texts(map_num, map)
	for i,v in map_text[map_num] do 
		table.insert(map.children, spawn_map_text(v));
	end;
end

function spawn_map_button(map_num)
	return scene:Spawn
	{
		name = "MAP_BUTTON_" .. map_num;
		gfx = { image = "map" .. map_num .. "_up" };
		
		command = function(actor)
			actor:SetDepthValue(500);
		end;
	};
end

function spawn_map_nameplate_small(map_num)
	return scene:Spawn
	{
		name = "MAP_NAME_PLATE_SMALL_" .. map_num;
		gfx = { image = "neighbourhood_nameplate_small" };
		
		command = function(actor)
			actor:SetDepthValue(501);
			actor:JumpToPoint(map_name_plate_small[map_num].position);
			actor:AddFlag(AFLAG.AFLAG_TEXT_ON_ACTOR);
			actor:AddFlag(AFLAG.AFLAG_NO_VOX);
			actor:ModifySaySpec(neighborhood_text_spec);
			actor:ModifySaySpec{ lineheight = map_name_plate_small[map_num].height; fixed = true; anchor = ANCHOR.CENTER; halign = HALIGN.RIGHT; w = 94, h = 23;}
			actor:SayRaw(scene:grabstring(map_name_plate_small[map_num].text));
		end;
	};
end

function position_maps()
	local selected_map = game:Get("currently_selected_map");
	
	if selected_map < 1 then
		selected_map = 1;
		game:Set("currently_selected_map", selected_map);
	end
	
	for i,v in map_data do
		if i ~= selected_map then
			--hide_map_icons(i);
			position_map(i, MAP_SMALL_SCALE, v.icon_offset, v.scale_pos, MAP_SMALL_DEPTH);
			scene["MAP_HALO_" .. i]:LoadZone("map_background");
			scene["MAP_BUTTON_" .. i]:LoadImage("map" .. i .. "_up");
		else
			--show_map_icons(i);
			position_map(i, 1, v.icon_offset, v.start_pos, MAP_LARGE_DEPTH);
			scene["MAP_HALO_" .. i]:DumpZone();
			scene["MAP_BUTTON_" .. i]:LoadImage("map" .. i .. "_selected");
		end
	end
	
	-- show or hide the you are here indicator
	--position_you_are_here();
end

function position_you_are_here()
	if scene.YOU_ARE_HERE then
		local selected_map = game:Get("currently_selected_map");
		local cur_scene = game:GetCurrentScene();
		
		if cur_scene == "subway" then -- special case for the subway
			if game:Get("cur_module") == selected_map then
				scene.YOU_ARE_HERE:SetAlpha(1);
				scene.YOU_ARE_HERE:LoadZone("quest/objects/flo");
			else
				scene.YOU_ARE_HERE:SetAlpha(0);
				scene.YOU_ARE_HERE:DumpZone();
			end
		else
			-- this makes the assumption that all scenes where you have access to the map start with m1, m2, or m3
			if string.byte(cur_scene, 2) == string.byte(tostring(selected_map)) then
				scene.YOU_ARE_HERE:SetAlpha(1);
				scene.YOU_ARE_HERE:LoadZone("quest/objects/flo");
			else
				scene.YOU_ARE_HERE:SetAlpha(0);
				scene.YOU_ARE_HERE:DumpZone();
			end
		end
	end
end

function switch_maps(flo, new_map)
	flo:StartProc(
		function(flo)
			flo:SetMode(MODE.CUTSCENE);
			local selected_map = game:Get("currently_selected_map");
			
			if selected_map < 1 then
				selected_map = 1;
			end
			
			if new_map == selected_map then
				flo:SetMode(MODE.FOLLOWCLICKS);
				return;
			end
			
			game:Set("currently_selected_map", new_map);
			
			for i,v in map_data do
				if i ~= new_map then
					scene["MAP_BUTTON_" .. i]:LoadImage("map" .. i .. "_up");
				else
					scene["MAP_BUTTON_" .. i]:LoadImage("map" .. i .. "_selected");
				end
				
				--hide_map_icons(i);
			end
			
			--scene.YOU_ARE_HERE:SetAlpha(0);
			
			-- scale current map back
			local cur_scale = 1;
			local des_scale = MAP_SMALL_SCALE;
			local scale_time = 30;
			local cur_pos = map_data[selected_map].start_pos;
			local des_pos = map_data[selected_map].scale_pos;
			local cur_time = 0;
			local icon_offset = map_data[selected_map].icon_offset;
			
			while cur_time < scale_time do
				local delta = cur_time/scale_time;
				
				local scale = cur_scale + (des_scale-cur_scale)*delta;
				local pos = { x = cur_pos.x + (des_pos.x-cur_pos.x)*delta, y = cur_pos.y + (des_pos.y-cur_pos.y)*delta };
				
				position_map(selected_map, scale, icon_offset, pos, MAP_LARGE_DEPTH);
				
				cur_time = cur_time + 1;
				delay(1);
			end
			
			for i,v in map_data do
				if i ~= new_map then
					hide_map_icons(i);
				else
					show_map_icons(i);
				end
			end
			
			position_map(selected_map, des_scale, icon_offset, des_pos, MAP_SMALL_DEPTH);
			
			-- scale new map forward
			cur_scale = MAP_SMALL_SCALE;
			des_scale = 1;
			cur_pos = map_data[new_map].scale_pos;
			des_pos = map_data[new_map].start_pos;
			cur_time = 0;
			icon_offset = map_data[new_map].icon_offset;
			
			while cur_time < scale_time do
				local delta = cur_time/scale_time;
				
				local scale = cur_scale + (des_scale-cur_scale)*delta;
				local pos = { x = cur_pos.x + (des_pos.x-cur_pos.x)*delta, y = cur_pos.y + (des_pos.y-cur_pos.y)*delta };
				
				position_map(new_map, scale, icon_offset, pos, MAP_LARGE_DEPTH);
				
				cur_time = cur_time + 1;
				delay(1);
			end
			
			position_map(new_map, des_scale, icon_offset, des_pos, MAP_LARGE_DEPTH);
			
			position_maps();
			
			flo:SetMode(MODE.FOLLOWCLICKS);
		end
	);
end

function position_map(map_num, scale, icon_offset, position, depth)
	local map = scene["MAP_" .. map_num];
	map:JumpToPoint(position);
	map:SetScale(scale);
	map:SetDepthValue(depth);
	
	local icon_position = { x = position.x + (icon_offset.x)*scale, y = position.y + (icon_offset.y)*scale };
	
	for i,v in map.children do
		v:JumpToPoint(icon_position);
		v:SetScale(scale);
		v:SetDepthValue(depth+i);
	end
	
	local map_halo = scene["MAP_HALO_" .. map_num];
	map_halo:JumpToPoint(icon_position);
	map_halo:SetScale(scale);
	map_halo:SetDepthValue(depth+map_num);
end

function hide_map_icons(map_num)
	local new_map = scene["MAP_" .. map_num];
	
	for i,v in new_map.children do
		v:Expire();
	end
	
	new_map.children = {};
end

function show_map_icons(map_num)
	local new_map = scene["MAP_" .. map_num];
	spawn_map_icons(map_num, new_map);
	table.insert(new_map.children, spawn_name_plate(map_num));
	spawn_map_texts(map_num, new_map);
	--table.insert(new_map.children, spawn_map_halo(map_num));
end

flo_spec =
{
	name = "FLO";

	command = function(actor)
		actor:ModifySaySpec(flo_text_spec)
		coroutine.yield(RESUME.NOW);
		--if game:Get("first_time_map") < 1 then
			game:Set("first_time_map", 1);
			help_panel_say_raw(scene:grabstring("map_intro_message"));
		--end
		actor:SetMode(MODE.FOLLOWCLICKS);
	end;
};

function spawn_map(map_num)
	return scene:Spawn
	{
		name = "MAP_" .. map_num;
		gfx = { image = "map" .. map_num .. "_background" };
		
		command = function(actor)
			actor:SetDepthValue(5);
			actor:JumpToPoint(map_data[map_num].start_pos);
			actor.children = {};
		end;
	}
end

function spawn_map_halo(map_num)
	return scene:Spawn
	{
		name = "MAP_HALO_" .. map_num;
		halo = "map_background";
		
		command = function(actor)
			actor:SetDepthValue(200);
			actor:JumpToPoint(map_data[map_num].start_pos);
		end;
		
		point_at_fn = function(actor, enter)
			if game:Get("currently_selected_map") == map_num then
				scene["MAP_BUTTON_" .. map_num]:LoadImage("map" .. map_num .. "_selected");
			elseif enter then
				scene["MAP_BUTTON_" .. map_num]:LoadImage("map" .. map_num .. "_over");
			else
				scene["MAP_BUTTON_" .. map_num]:LoadImage("map" .. map_num .. "_up");
			end
		end;
		
		on_click = function(flo, actor)
			switch_maps(flo, map_num);
		end;
	}
end

function spawn_name_plate(map_num)
	return scene:Spawn
	{
		name = "MAP_NAME_PLATE_" .. map_num;
		gfx = { image = "nieghborhood_nameplate" };
		
		command = function(actor)
			actor:SetDepthValue(10);
		end;
	}
end

function spawn_map_icon(icon_data)
	return scene:Spawn
	{
		name = string.upper(icon_data[ICON_DATA.NAME]);
		halo = icon_data[ICON_DATA.NAME];
		point_at_name = icon_data[ICON_DATA.NAME];
		
		command = function(actor)
			if icon_data[ICON_DATA.VISIBLE] then
				if icon_data[ICON_DATA.CONDITION] or testmap == true then
					actor:LoadImage(icon_data[ICON_DATA.ON]);
				else
					actor:LoadImage(icon_data[ICON_DATA.OFF]);
				end
				actor:SetDepthValue(10);
				
				if icon_data[ICON_DATA.HALO_WHEN_OFF] == false and (icon_data[ICON_DATA.CONDITION] == false and testmap == false) then
					actor:DumpZone();
				end
			else
				actor:Expire();
			end
		end;
	}
end

function spawn_map_text(text_data)
	return scene:Spawn
	{
		name = "TEXT_" .. string.upper(text_data[TEXT_DATA.TEXT]);
		
		command = function(actor)
			actor:AddFlag(AFLAG.AFLAG_TEXT_ON_ACTOR);
			actor:AddFlag(AFLAG.AFLAG_NO_VOX);
			actor:SetDepthValue(15);
			actor:ModifySaySpec(text_data[TEXT_DATA.TEXT_SPEC]);
			--actor:ModifySaySpec{ x = text_data[TEXT_DATA.POSITION].x, y = text_data[TEXT_DATA.POSITION].y };
			actor:Say(text_data[TEXT_DATA.TEXT]);
			actor:SetPolygon(text_data[TEXT_DATA.POSITION][1], text_data[TEXT_DATA.POSITION][2], text_data[TEXT_DATA.POSITION][3], text_data[TEXT_DATA.POSITION][4]);
			actor:TextToImage(0, 0);
			--actor:AltTextToImage();
		end;
	}
end

you_are_here_icon_spec = 
{
	name = "YOU_ARE_HERE";
	gfx = { anim = "anim/flo/stands" };
	point_at_name = "you_are_here";
	halo = "quest/objects/flo";
	
	command = function(actor)
		actor:SetDepthValue(300);
		actor:AddFlag(AFLAG.AFLAG_SPECIAL_ANIM);
		actor:PlayAnim("DoStandS");
		actor:SetScale(0.2);
		
		local map_pos = game:GetString("map_position");
		actor:JumpToNamedPoint(map_pos);
		
		position_you_are_here();
	end;
}

function go_back(flo)
	flo:SetMode(MODE.CUTSCENE);
	kill_help_panel();
	scene:SetDrawEnvSlideSpeed(-0.06);
	--raise_hud();
	
	while not scene:IsDrawEnvSlideDone() do
		delay(1);
	end
	
	if game:Get("florida_tutorial") == 2 then
		game:Set("florida_tutorial", 3);
	end
	
	scene:ReturnFromScene();
end;

back_spec = 
{
	name = "BACK";
	halo = "background";
	--point_at_name = "back";
	--point_at_color = { a  = 1, r = 1, g = 0, b = 0 };
	
	command = function(actor)
		actor:SetDepthValue(5);
		actor:SetPointAtCursor("cursor_exit");
	end;
		
	on_arrive = function(flo, actor)
		flo:StartProc(go_back);
	end;
	
	on_use_inv = function(item, flo, actor)
		flo:StartProc(go_back);
		return RESPONSE.INV_HANDLED;
	end;
}

scene_setup =
{
	name = "SETUP",
	command = function(actor)
		if IsCheatMode() then
			--testing data
			--[[game:Set("map_m1_diner_coffee", 1);
			game:Set("map_m1_diner_mop", 1);
			game:Set("map_m1_diner_ring", 1);
			game:Set("map_m1_florida_bag", 1);
			game:Set("map_m1_florida_dye", 1);
			game:Set("map_m1_petspa_wirecutters", 1);]]
		end
		
		scene:SetDrawEnvSlidePos(0.0);
		scene:SetCameraFollowActor(nil);
		
		fade_scene_up(true, true);
		scene.PAUSE_BUTTON_HELP:Expire()
		scene.BACK_BUTTON:Expire();
		lower_hud();
		game:ClearInvUsage();
		MET_Count("MapVisited");
		
		-- Example use of tooltip color setting [defaults are black edge, grey fill]		
		SetToolTipFillColor { r = 1, g = 1, b = 0.35, a = 0.5};
		SetToolTipEdgeColor { r = 0, g = 0, b = 0, a = 0.5};
		SetToolTipMargins(5, 2);
		
		scene:ModifySaySpec
		{
			outline_size = 0;
			color = { a = 1, r = 0, g = 0, b = 0 };
			lineheight = 20,
			font = "fonts/dom_casual_std.mvec",
		}
		
		local cur_module = game:Get("cur_module");
		
		if cur_module < 1 then
			cur_module = 1;
		end
		
		game:Set("currently_selected_map", cur_module);
		
		spawn_maps();
	end;
};

scene_spec =
{
	atlas = 
	{
		"pieces1",
		"pieces2",
		"pieces3",
	};
	
	bg_image = 
	{
		{ "background", 1 },
	};
	
	ground = "background";
	
	actorlist = 
	{
		scene_setup,
		--back_spec,
	};
};